package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.DatosAvisoDao;
import com.ejie.ab04b.model.DatosAviso;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0468s00ServiceImpl generated by UDA, 21-Feb-2017 12:47:21.
 * 
 * @author UDA
 */

@Service(value = "ab0468s00Service")
public class DatosAvisoServiceImpl implements DatosAvisoService {

	@Autowired()
	private DatosAvisoDao ab0468s00Dao;

	/**
	 * Inserts a single row in the Ab0468s00 table.
	 * 
	 *  ab0468s00
	 *            Ab0468s00
	 *  Ab0468s00
	 *
	 * @param ab0468s00 the ab 0468 s 00
	 * @return the datos aviso
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DatosAviso add(DatosAviso ab0468s00) {
		return this.ab0468s00Dao.add(ab0468s00);
	}

	/**
	 * Updates a single row in the Ab0468s00 table.
	 * 
	 *  ab0468s00
	 *            Ab0468s00
	 *  Ab0468s00
	 *
	 * @param ab0468s00 the ab 0468 s 00
	 * @return the datos aviso
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DatosAviso update(DatosAviso ab0468s00) {
		return this.ab0468s00Dao.update(ab0468s00);
	}

	/**
	 * Finds a single row in the Ab0468s00 table.
	 * 
	 *  ab0468s00
	 *            Ab0468s00
	 *  Ab0468s00
	 *
	 * @param ab0468s00 the ab 0468 s 00
	 * @return the datos aviso
	 */
	public DatosAviso find(DatosAviso ab0468s00) {
		return (DatosAviso) this.ab0468s00Dao.find(ab0468s00);
	}

	/**
	 * Deletes a single row in the Ab0468s00 table.
	 * 
	 *  ab0468s00
	 *            Ab0468s00
	 *
	 * @param ab0468s00 the ab 0468 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DatosAviso ab0468s00) {
		this.ab0468s00Dao.remove(ab0468s00);
	}

	/**
	 * Finds a list of rows in the Ab0468s00 table.
	 * 
	 *  ab0468s00
	 *            Ab0468s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0468s00>
	 *
	 * @param ab0468s00 the ab 0468 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<DatosAviso> findAll(DatosAviso ab0468s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<DatosAviso>) this.ab0468s00Dao.findAll(ab0468s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0468s00 table using like.
	 * 
	 *  ab0468s00
	 *            Ab0468s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0468s00>
	 *
	 * @param ab0468s00 the ab 0468 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<DatosAviso> findAllLike(DatosAviso ab0468s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<DatosAviso>) this.ab0468s00Dao.findAllLike(ab0468s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0468s00 table.
	 * 
	 *  filterAb0468s00
	 *            Ab0468s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0468s00>
	 *
	 * @param filterAb0468s00 the filter ab 0468 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<DatosAviso> filter(DatosAviso filterAb0468s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<DatosAviso> listaAb0468s00 = this.ab0468s00Dao
				.findAllLike(filterAb0468s00, jqGridRequestDto, false);
		Long recordNum = this.ab0468s00Dao.findAllLikeCount(
				filterAb0468s00 != null ? filterAb0468s00 : new DatosAviso(),
				false);
		if (jqGridRequestDto!=null && jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<DatosAviso>> reorderSelection = this.ab0468s00Dao
					.reorderSelection(filterAb0468s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<DatosAviso>(jqGridRequestDto,
					recordNum, listaAb0468s00, reorderSelection);
		}
		return new JQGridResponseDto<DatosAviso>(jqGridRequestDto, recordNum,
				listaAb0468s00);
	}

	/**
	 * Searches rows in the Ab0468s00 table.
	 * 
	 *  filterAb0468s00
	 *            Ab0468s00
	 *  searchAb0468s00
	 *            Ab0468s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0468s00>>
	 *
	 * @param filterAb0468s00 the filter ab 0468 s 00
	 * @param searchAb0468s00 the search ab 0468 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<DatosAviso>> search(DatosAviso filterAb0468s00,
			DatosAviso searchAb0468s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab0468s00Dao.search(filterAb0468s00, searchAb0468s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0468s00 table.
	 * 
	 *  filterAb0468s00
	 *            Ab0468s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0468s00 the filter ab 0468 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(DatosAviso filterAb0468s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0468s00Dao.reorderSelection(filterAb0468s00,
				jqGridRequestDto, startsWith);
	}

}
